from bpy.types import Operator
from ....libs.functions.basics import deselect_all_objects, set_active_object
from ....libs.functions.get_common_vars import get_common_vars
from .common_methods import reset_properties_to_defaults


class FLUIDLAB_OT_ff_forces_colliders_rm(Operator):
    bl_idname = "fluidlab.forces_collliders_rm"
    bl_label = "Remove Force"
    bl_description = "Remove Collider Force"
    bl_options = {'REGISTER', 'UNDO'}


    def execute(self, context):

        previous_selection = context.selected_objects
        previous_active = context.active_object

        fluid_colliders = get_common_vars(context, get_fluid_colliders=True)

        active_collider = fluid_colliders.active
        if not active_collider:
            print("no active_collider!")
            return {'CANCELLED'}

        colliders_obs = [c_ob.ob for c_ob in active_collider.colliders] 

        # Si no hay objeto collider:
        if not colliders_obs:
            print("no colliders objects in the item!")
            return {'CANCELLED'}

        for c_ob in colliders_obs:
            collider_ob = c_ob

            if collider_ob.name not in context.view_layer.objects:
                continue

            deselect_all_objects(context)
            set_active_object(context, collider_ob)
            collider_ob.select_set(True)
            field = collider_ob.field
            reset_properties_to_defaults(field)
            field.type = 'NONE'

        if previous_active:
            set_active_object(context, previous_active)

        deselect_all_objects(context)
        if previous_selection:
            for obj in previous_selection:
                obj.select_set(True)

        return {'FINISHED'}